import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import seaborn as sns
import pickle
from decision_company import read_csv_file, create_figure, set_plot_ylabel, set_plot_xlabel, set_plot_title, show_plots, save_plot, draw_lineplot, plot_kde, add_legend, draw_countplot


atp_tennis = read_csv_file('atp_tennis.csv')

# First set of plots: Distribution of Original and Updated Odds for Player 1
create_figure((12, 6))
plot_kde(updated_odds_df['Original Odd_1'], 'Original Odd_1', True)
plot_kde(updated_odds_df['Updated Odd_1'], 'Updated Odd_1', True)
set_plot_xlabel('Odds')
set_plot_ylabel('Density')
set_plot_title('Distribution of Original and Updated Odds for Player 1')
add_legend()
save_plot('./ref_result/updated_odds_change_for_player_1.png')
show_plots()

# Second set of plots: Distribution of Original and Updated Odds for Player 2
create_figure((12, 6))
plot_kde(updated_odds_df['Original Odd_2'], 'Original Odd_2', True)
plot_kde(updated_odds_df['Updated Odd_2'], 'Updated Odd_2', True)
set_plot_xlabel('Odds')
set_plot_ylabel('Density')
set_plot_title('Distribution of Original and Updated Odds for Player 2')
add_legend()
save_plot('./ref_result/updated_odds_change_for_player_2.png')
show_plots()

# Third set of plots: Changes in Match Favorites Based on Updated Odds
create_figure((12, 6))
draw_countplot('Change in Favorite', later_rounds_odds)
set_plot_xlabel('Change in Match Favorite')
set_plot_ylabel('Count')
set_plot_title('Changes in Match Favorites Based on Updated Odds')
save_plot('./ref_result/changes_in_match_favorites.png')
show_plots()

# Fourth set of plots: Shifts in Tournament Dynamics Based on Updated Odds
create_figure((12, 6))
draw_lineplot('Match ID', 'Shift in Tournament Dynamics', data=later_rounds_odds)
set_plot_xlabel('Match ID')
set_plot_ylabel('Shift in Tournament Dynamics')
set_plot_title('Shifts in Tournament Dynamics Based on Updated Odds')
save_plot('./ref_result/shifts_in_tournament_dynamics.png')
show_plots()